/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.misc.Misc;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapDimension;

public class SupportXaeroWorldmap {
    public static int WORLDMAP_COMPATIBILITY_VERSION = 7;
    public int compatibilityVersion;
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private IXaeroMinimap modMain;

    public SupportXaeroWorldmap(IXaeroMinimap modMain) {
        this.modMain = modMain;
        try {
            this.compatibilityVersion = WorldMap.MINIMAP_COMPATIBILITY_VERSION;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (this.compatibilityVersion < 3) {
            throw new RuntimeException("Xaero's World Map 1.11.0 or newer required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(XaeroMinimapSession minimapSession, MatrixStack matrixStack, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom, IVertexBuilder overlayBufferBuilder, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!mapProcessor.isRenderingPaused()) {
                String worldString;
                if (mapProcessor.getCurrentDimension() == null) {
                    return;
                }
                String string = worldString = this.compatibilityVersion >= 7 ? mapProcessor.getCurrentWorldId() : mapProcessor.getCurrentWorldString();
                if (worldString == null) {
                    return;
                }
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                float brightness = this.getMinimapBrightness();
                boolean wmUsesHashcodes = this.compatibilityVersion >= 5;
                int globalRegionCacheHashCode = wmUsesHashcodes ? WorldMap.settings.getRegionCacheHashCode() : 0;
                boolean reloadEverything = wmUsesHashcodes ? WorldMap.settings.reloadEverything : false;
                int globalReloadVersion = wmUsesHashcodes ? WorldMap.settings.reloadVersion : 0;
                boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession.getWaypointsManager());
                MultiTextureRenderTypeRenderer mapWithLightRenderer = null;
                MultiTextureRenderTypeRenderer mapNoLightRenderer = null;
                if (this.compatibilityVersion >= 9) {
                    mapWithLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> {
                        GlStateManager.func_227756_r_((int)33984);
                        GlStateManager.func_227760_t_((int)t);
                        GlStateManager.func_227756_r_((int)33985);
                        GlStateManager.func_227760_t_((int)t);
                        GlStateManager.func_227756_r_((int)33986);
                        GlStateManager.func_227760_t_((int)t);
                    }, CustomRenderTypes.MAP_WITH_LIGHT);
                    mapNoLightRenderer = multiTextureRenderTypeRenderers.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP_NO_LIGHT);
                    RenderSystem.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                } else {
                    if (this.compatibilityVersion >= 7) {
                        GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
                    }
                    if (this.compatibilityVersion >= 6) {
                        GuiMap.setupTextureMatricesAndTextures((float)brightness);
                    } else if (this.compatibilityVersion == 5) {
                        GuiMap.setupTextureMatrices();
                    }
                }
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        MapTileChunk chunk;
                        MapRegion region = mapProcessor.getMapRegion(i >> 3, j >> 3, mapProcessor.regionExists(i >> 3, j >> 3));
                        if (region == null) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            int regionReloadVersion;
                            int regionHashCode = wmUsesHashcodes ? region.getCacheHashCode() : 0;
                            int n = regionReloadVersion = wmUsesHashcodes ? region.getReloadVersion() : 0;
                            if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten() || region.getLoadState() == 0) && (reloadEverything && regionReloadVersion != globalReloadVersion || regionHashCode != globalRegionCacheHashCode || region.getVersion() != mapProcessor.getGlobalVersion() || region.getLoadState() != 2 && region.shouldCache())) {
                                if (region.getLoadState() == 2) {
                                    region.requestRefresh(mapProcessor);
                                } else {
                                    mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap", false);
                                    mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                                }
                            }
                        }
                        if (!mapProcessor.isUploadingPaused()) {
                            if (this.compatibilityVersion >= 7) {
                                if (region.isLoaded()) {
                                    mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(region);
                                }
                            } else {
                                List regions = mapProcessor.getMapWorld().getCurrentDimension().getMapRegionsList();
                                regions.remove(region);
                                regions.add(region);
                            }
                        }
                        if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ || (chunk = region.getChunk(i & 7, j & 7)) == null || chunk.getGlColorTexture() == -1) continue;
                        this.bindMapTextureWithLighting(brightness, chunk, zooming);
                        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                        int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                        int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                        if (this.compatibilityVersion < 7) {
                            GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                            GuiMap.renderTexturedModalRectWithLighting((float)drawX, (float)drawZ, (int)0, (int)0, (float)64.0f, (float)64.0f);
                        } else if (this.compatibilityVersion < 9) {
                            GuiMap.renderTexturedModalRectWithLighting((float)drawX, (float)drawZ, (float)64.0f, (float)64.0f);
                        } else {
                            this.prepareMapTexturedRect(matrix, drawX, drawZ, 0, 0, 64.0f, 64.0f, chunk, mapNoLightRenderer, mapWithLightRenderer, helper);
                        }
                        if (slimeChunks) {
                            boolean newSeed;
                            if (this.compatibilityVersion < 9) {
                                GuiMap.restoreTextureStates();
                                if (this.compatibilityVersion >= 7) {
                                    GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
                                }
                            }
                            Long seed = this.modMain.getSettings().getSlimeChunksSeed(minimapSession.getWaypointsManager().getCurrentContainerAndWorldID());
                            Long savedSeed = seedsUsed.get(chunk);
                            boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
                            if (newSeed) {
                                seedsUsed.put(chunk, seed);
                            }
                            for (int t2 = 0; t2 < 16; ++t2) {
                                if (newSeed || (chunk.getTileGridsCache()[t2 % 4][t2 / 4] & 1) == 0) {
                                    chunk.getTileGridsCache()[t2 % 4][t2 / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t2 % 4, chunk.getZ() * 4 + t2 / 4, seed) ? 2 : 0));
                                }
                                if ((chunk.getTileGridsCache()[t2 % 4][t2 / 4] & 2) == 0) continue;
                                int slimeDrawX = drawX + 16 * (t2 % 4);
                                int slimeDrawZ = drawZ + 16 * (t2 / 4);
                                helper.addColoredRectToExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
                            }
                            if (this.compatibilityVersion < 9) {
                                if (this.compatibilityVersion >= 6) {
                                    GuiMap.setupTextures((float)brightness);
                                }
                                if (this.compatibilityVersion >= 7) {
                                    GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
                                    RenderSystem.enableBlend();
                                }
                            }
                        }
                        if (this.compatibilityVersion >= 7) continue;
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.enableBlend();
                    }
                }
                if (this.compatibilityVersion >= 9) {
                    multiTextureRenderTypeRenderers.draw(mapWithLightRenderer);
                    multiTextureRenderTypeRenderers.draw(mapNoLightRenderer);
                } else {
                    GuiMap.restoreTextureStates();
                }
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.disableBlend();
            }
        }
    }

    public boolean getWorldMapWaypoints() {
        return WorldMap.settings.waypoints;
    }

    public int getWorldMapColours() {
        return WorldMap.settings.colours;
    }

    public boolean getWorldMapFlowers() {
        return WorldMap.settings.flowers;
    }

    public boolean getWorldMapLighting() {
        return WorldMap.settings.lighting;
    }

    public boolean getWorldMapTerrainDepth() {
        return WorldMap.settings.terrainDepth;
    }

    public int getWorldMapTerrainSlopes() {
        int wmSetting = WorldMap.settings.terrainSlopes;
        if (this.compatibilityVersion >= 5) {
            return wmSetting;
        }
        return wmSetting == 2 ? 3 : wmSetting;
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        return WorldMap.settings.biomeColorsVanillaMode;
    }

    public boolean getWorldMapIgnoreHeightmaps() {
        return WorldMap.settings.getClientBooleanValue(ModOptions.IGNORE_HEIGHTMAPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldId(RegistryKey<World> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim;
            MapDimension mapDimension = mapDim = !mapProcessor.isMapWorldUsable() || mapProcessor.isWaitingForWorldUpdate() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : (!mapDim.currentMultiworldWritable ? "minimap" : mapDim.getCurrentMultiworld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPotentialMultiworldIds(RegistryKey<World> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null || !mapProcessor.isWaitingForWorldUpdate() && mapDim.currentMultiworldWritable ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMultiworldIds(RegistryKey<World> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiworldName(RegistryKey<World> dimId, String multiworldId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
        }
    }

    public void openSettings() {
        Screen currentEscScreen;
        Screen current = Minecraft.func_71410_x().field_71462_r;
        Screen screen = currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        if (this.compatibilityVersion >= 8) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldMapSettings(current, currentEscScreen));
        } else {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiWorldMapSettings(current));
        }
    }

    public float getMinimapBrightness() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        if (this.compatibilityVersion < 4) {
            return mapProcessor.getBrightness();
        }
        return mapProcessor.getBrightness(this.modMain.getSettings().getLighting());
    }

    private int bindMapTextureWithLighting(float brightness, MapTileChunk chunk, boolean zooming) {
        if (this.compatibilityVersion >= 9) {
            chunk.getLeafTexture().bindColorTexture(false, zooming ? 9729 : 9728);
        } else if (this.compatibilityVersion >= 7) {
            GuiMap.bindMapTextureWithLighting3((MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        } else if (this.compatibilityVersion >= 6) {
            GuiMap.bindMapTextureWithLighting3((float)brightness, (MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        } else if (this.compatibilityVersion >= 5) {
            GuiMap.bindMapTextureWithLighting2((float)brightness, (MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        } else {
            GuiMap.bindMapTextureWithLighting((float)brightness, (MapTileChunk)chunk, (int)(zooming ? 9729 : 9728), (int)0);
        }
        return 0;
    }

    public boolean screenShouldSkipWorldRender(Screen screen) {
        if (this.compatibilityVersion < 8) {
            return false;
        }
        return Misc.screenShouldSkipWorldRender((Screen)screen, (boolean)false);
    }

    public void prepareMapTexturedRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, MapTileChunk chunk, MultiTextureRenderTypeRenderer noLightRenderer, MultiTextureRenderTypeRenderer withLightrenderer, MinimapRendererHelper helper) {
        LeafRegionTexture texture = chunk.getLeafTexture();
        if (texture.getTextureHasLight()) {
            BufferBuilder vertexBuffer = withLightrenderer.begin(7, GuiMap.POSITION_TEX_TEX_TEX, texture.getGlColorTexture());
            vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + height, 0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)0.0f, (float)1.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)0.0f, (float)1.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)0.0f, (float)1.0f);
            vertexBuffer.func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + width, y + height, 0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)1.0f, (float)1.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)1.0f, (float)1.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)1.0f, (float)1.0f);
            vertexBuffer.func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + width, y + 0.0f, 0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)1.0f, (float)0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)1.0f, (float)0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)1.0f, (float)0.0f);
            vertexBuffer.func_181675_d();
            vertexBuffer.func_227888_a_(matrix, x + 0.0f, y + 0.0f, 0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)0.0f, (float)0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)0.0f, (float)0.0f);
            GuiMap.anyIndexFloatUV((BufferBuilder)vertexBuffer, (float)0.0f, (float)0.0f);
            vertexBuffer.func_181675_d();
        } else {
            helper.prepareMyTexturedModalRect(matrix, x, y, textureX, (int)height, width, height, -height, 64.0f, texture.getGlColorTexture(), noLightRenderer);
        }
    }
}

